<?php
declare(strict_types=1);
require __DIR__ . '/_helper.php';

$error = '';
try {
    if (installer_locked()) throw new RuntimeException("Installer locked.");
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
    $csrf = csrf_token();

    $cfg = load_config();
    $conn = db_connect($cfg);

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        csrf_check();

        $app_name = trim((string)($_POST['app_name'] ?? 'MyApp'));
        $email = trim((string)($_POST['email'] ?? ''));
        $password = (string)($_POST['password'] ?? '');
        $license_key = trim((string)($_POST['license_key'] ?? ''));

        if ($app_name === '') $error = "App name is required.";
        elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) $error = "Invalid email.";
        elseif (strlen($password) < 6) $error = "Password must be at least 6 characters.";
        else {
            $exists = $conn->query("SELECT COUNT(*) c FROM admin_users");
            $row = $exists ? $exists->fetch_assoc() : ['c'=>0];
            if ((int)($row['c'] ?? 0) === 0) {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $conn->prepare("INSERT INTO admin_users (email, password_hash) VALUES (?, ?)");
                $stmt->bind_param("ss", $email, $hash);
                $stmt->execute();
            }

            $stmt2 = $conn->prepare("UPDATE settings SET app_name=?, license_key=? WHERE id=1");
            $stmt2->bind_param("ss", $app_name, $license_key);
            $stmt2->execute();

            header("Location: step4_finish.php");
            exit;
        }
    }
} catch (Throwable $e) {
    $error = $e->getMessage();
    if (session_status() !== PHP_SESSION_ACTIVE) session_start();
    $csrf = csrf_token();
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Installer - Step 3</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body style="font-family: Arial, sans-serif; max-width: 760px; margin: 32px auto; line-height: 1.4;">
  <h2>Installer — Step 3 (Admin + License)</h2>

  <?php if (!empty($error)): ?>
    <div style="background:#ffe6e6; border:1px solid #ffb3b3; padding:12px; margin: 12px 0;">
      <?=h($error)?>
    </div>
  <?php endif; ?>

  <form method="post" style="display:grid; gap:10px;">
    <input type="hidden" name="csrf" value="<?=h($csrf)?>">

    <label>App Name</label>
    <input name="app_name" value="MyApp" required style="padding:10px;">

    <label>Admin Email</label>
    <input name="email" placeholder="admin@example.com" required style="padding:10px;">

    <label>Admin Password</label>
    <input name="password" type="password" required style="padding:10px;">

    <label>License Key</label>
    <input name="license_key" placeholder="ODNEXS-2026-ABC123" style="padding:10px;">

    <button style="padding:10px 14px;">Finish</button>
  </form>

  <p style="color:#555; margin-top: 14px;">
    You can leave License Key empty and add it later (in DB <code>settings</code> table).
  </p>
</body>
</html>
