<?php
declare(strict_types=1);
require __DIR__ . '/_helper.php';

try {
    if (installer_locked()) throw new RuntimeException("Installer locked.");
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') throw new RuntimeException("Invalid request.");
    csrf_check();

    $d = require_post_fields(['db_host','db_name','db_user','db_pass','license_url']);

    $cfg = [
        'db_host' => $d['db_host'],
        'db_name' => $d['db_name'],
        'db_user' => $d['db_user'],
        'db_pass' => $d['db_pass'],
        'license_url' => $d['license_url'],
        'license_cache_ttl' => 86400,
    ];

    $conn = db_connect($cfg);

    $conn->query("CREATE TABLE IF NOT EXISTS settings (
        id INT PRIMARY KEY AUTO_INCREMENT,
        app_name VARCHAR(100) NOT NULL DEFAULT 'MyApp',
        license_key VARCHAR(64) DEFAULT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    $conn->query("CREATE TABLE IF NOT EXISTS admin_users (
        id INT PRIMARY KEY AUTO_INCREMENT,
        email VARCHAR(255) UNIQUE NOT NULL,
        password_hash VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

    $res = $conn->query("SELECT id FROM settings WHERE id=1 LIMIT 1");
    if (!$res || $res->num_rows === 0) {
        $stmt = $conn->prepare("INSERT INTO settings (id, app_name) VALUES (1, 'MyApp')");
        $stmt->execute();
    }

    write_config($cfg);

    header("Location: step3_admin.php");
    exit;
} catch (Throwable $e) {
    http_response_code(400);
    echo "<pre style='font-family:Arial'>Error: " . h($e->getMessage()) . "</pre>";
}
